#!/bin/sh

<<BLOCK
if [ -f BOOT_V1.bin ];then
	md5boot=`cat md5.txt | grep BOOT_V1.bin | cut -c 32`
	md5boot_real=`md5sum BOOT_V1.bin | cut -c 32`
	if [ $md5boot = $md5boot_real ];then
		echo "flash BOOT_V1.bin..."
		flash_erase /dev/mtd0 0x0 0x140
		nandwrite -p -s 0x0 /dev/mtd0 BOOT_V1.bin
	else
		exit -10
	fi
elif [ -f BOOT_V2.bin ];then
	md5boot=`cat md5.txt | grep BOOT_V2.bin | cut -c 32`
	md5boot_real=`md5sum BOOT_V2.bin | cut -c 32`
	if [ $md5boot = $md5boot_real ];then
		echo "flash BOOT_V2.bin..."
#		flash_erase /dev/mtd0 0x0 0x88
		flash_erase /dev/mtd0 0x0 0x58
		nandwrite -p -s 0x0 /dev/mtd0 BOOT_V2.bin
	else
		exit -11
	fi
fi
BLOCK

if [ -f BOOT.bin ];then
	md5boot=`cat md5.txt | grep BOOT.bin | cut -c 32`
	md5boot_real=`md5sum BOOT.bin | cut -c 32`
	if [ $md5boot = $md5boot_real ];then
		echo "flash BOOT.bin..."
		flash_erase /dev/mtd0 0x0 0x58
		nandwrite -p -s 0x0 /dev/mtd0 BOOT.bin
	else
		exit -10
	fi
fi

if [ -f devicetree.dtb ];then
	md5devicetree=`cat md5.txt | grep devicetree.dtb | cut -c 32`
	md5devicetree_real=`md5sum devicetree.dtb | cut -c 32`
	if [ $md5devicetree = $md5devicetree_real ];then
		echo "flash devicetree.dtb..."
		flash_erase /dev/mtd0 0xb00000 0x08
		nandwrite -p -s 0xb00000 /dev/mtd0 devicetree.dtb
	else
		exit -12
	fi
fi

if [ -f uImage ];then
	md5uImage=`cat md5.txt | grep uImage | cut -c 32`
	md5uImage_real=`md5sum uImage | cut -c 32`
	if [ $md5uImage = $md5uImage_real ];then
		echo "flash uImage..."
		#flash_erase /dev/mtd0 0xc00000 0xB0
		flash_erase /dev/mtd0 0xc00000 0xE0
		nandwrite -p -s 0xc00000 /dev/mtd0 uImage
	else
		exit -13
	fi
fi

if [ -f uramdisk.image.gz ];then
	md5fs=`cat md5.txt | grep uramdisk.image.gz | cut -c 32`
	md5fs_real=`md5sum uramdisk.image.gz | cut -c 32`
	if [ $md5fs = $md5fs_real ];then
		echo "flash uramdisk.image.gz..."
		flash_erase /dev/mtd1 0x0 0x200
		#flash_erase /dev/mtd1 0x0 0x400
		nandwrite -p -s 0x0 /dev/mtd1 uramdisk.image.gz
	else
		exit -14
	fi
fi

if [ -f FirmewareBak.tar.gz ];then
#	if [ ! -f /media/firmwarebak/FirmewareBak.tar.gz ];then
	md5fsfb=`cat md5.txt | grep FirmewareBak.tar.gz | cut -c 32`
	md5fsfb_real=`md5sum FirmewareBak.tar.gz | cut -c 32`
	if [ $md5fsfb = $md5fsfb_real ];then
		echo "flash FirmewareBak.tar.gz..."
		if [ ! -d /media/firmwarebak ];then
			mkdir /media/firmwarebak
		fi
		flash_erase /dev/mtd2 0x0 0x200
		mount -t jffs2 /dev/mtdblock2 /media/firmwarebak
		cp FirmewareBak.tar.gz /media/firmwarebak
	else
		exit -15
	fi
fi

cd -
