#!/bin/sh

set -e

failure() { echo "$1";  exit 1; }

fwinfo() {
	awk "/$1/ { print \$2 }" /etc/fw-info | tr -d '",'
}

if [ -f /etc/fw-info ]; then
	plat=$(fwinfo platform)
	inst_type=$(fwinfo install_type)

	if [ -n "$plat" ] && [ "$plat" != "aml" ]; then
		failure "Wrong firmware update file, target platform is aml"
	fi

	if [ -n "$inst_type" ] && [ "$inst_type" != "sd" ]; then
		failure "Wrong firmware update file, target installation type is sd"
	fi
fi

if [ -f fw.md5 ]; then
	echo "Verifying md5 checksums"
    md5sum -s -c fw.md5 > /dev/null 2>&1
fi

if [ -e aml_boot_package.enc ]; then
	echo "Updating aml_boot_package.enc"
	flash_erase /dev/mtd4 0x0 0xFF >/dev/null 2>&1
	nandwrite -p -s 0x0 /dev/mtd4 aml_boot_package.enc > /dev/null 2>&1
fi

sync