#!/bin/sh

set -e

failure() { echo "$1";  exit 1; }

fwinfo() {
	awk "/$1/ { print \$2 }" /etc/fw-info | tr -d '",'
}

if [ -f /etc/fw-info ]; then
	plat=$(fwinfo platform)
	inst_type=$(fwinfo install_type)

	if [ -n "$plat" ] && [ "$plat" != "xil" ]; then
		failure "Wrong firmware update file, target platform is xil"
	fi

	if [ -n "$inst_type" ] && [ "$inst_type" != "sd" ]; then
		failure "Wrong firmware update file, target installation type is sd"
	fi
fi

if [ -f fw.md5 ]; then
	echo "Verifying md5 checksums"
    md5sum -s -c fw.md5 > /dev/null 2>&1
fi

if [ ! -d /mnt/mmc ]; then
	echo "SD card not mounted"
	exit 1
fi

if [ -e boot.bin ]; then
	echo "Updating boot.bin"
	cp -f boot.bin /mnt/mmc > /dev/null 2>&1
fi

if [ -e devicetree.dtb ]; then
	echo "Updating devicetree.dtb"
	cp -f devicetree.dtb /mnt/mmc > /dev/null 2>&1
	cp -f devicetree.dtb.sig /mnt/mmc > /dev/null 2>&1
fi

if [ -e miner.btm ]; then
	echo "Updating miner.btm"
	cp -f miner.btm /mnt/mmc > /dev/null 2>&1
	cp -f miner.btm.sig /mnt/mmc > /dev/null 2>&1
fi

if [ -e uEnv.txt ]; then
	echo "Updating uEnv.txt"
	cp -f uEnv.txt /mnt/mmc > /dev/null 2>&1
fi

if [ -e uImage ]; then
	echo "Updating uImage"
	cp -f uImage /mnt/mmc > /dev/null 2>&1
	cp -f uImage.sig /mnt/mmc > /dev/null 2>&1
fi

if [ -e update.image.gz ]; then
	echo "Updating update.image.gz"
	cp -f update.image.gz /mnt/mmc > /dev/null 2>&1
	cp -f update.image.gz.sig /mnt/mmc > /dev/null 2>&1
fi

if ubiattach -d 4 -m 2; then
	mkdir -p /tmp/stock-config
	if mount -t ubifs ubi4_0 /tmp/stock-config; then
		if [ -e /tmp/stock-config/sn ]; then
			cp /tmp/stock-config/sn "/config/serial" || true
		fi
		umount /tmp/stock-config
	fi
	ubidetach -d 4
fi

sync